/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view.undo;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutStore;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.undo.GraphCommand;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.Exceptions;

public class LayoutCommand
extends GraphCommand {
    private Map<EntityID, Point> _centersBefore;
    private Map<EntityID, Point> _centersAfter;
    private Map<LinkID, List<Point>> _bendsBefore;
    private Map<LinkID, List<Point>> _bendsAfter;
    private boolean _isSignificant;

    public LayoutCommand(GraphID graphID, boolean isSignificant) {
        super(graphID);
        try {
            this._centersBefore = this.getCenters();
            this._bendsBefore = this.getBends();
            this._isSignificant = isSignificant;
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public LayoutCommand(GraphID graphID, Map<EntityID, Point> centersBefore, Map<EntityID, Point> centersAfter, Map<LinkID, List<Point>> bendsBefore, Map<LinkID, List<Point>> bendsAfter, boolean isSignificant) {
        super(graphID);
        this._centersBefore = centersBefore;
        this._centersAfter = centersAfter;
        this._bendsBefore = bendsBefore;
        this._bendsAfter = bendsAfter;
        this._isSignificant = isSignificant;
    }

    public void execute() {
        if (this._centersAfter == null) {
            this.undo();
        } else {
            try {
                this.setCenters(this._centersAfter);
                this.setPaths(this._bendsAfter);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void undo() {
        try {
            this.setCenters(this._centersBefore);
            this.setPaths(this._bendsBefore);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean isSignificant() {
        return this._isSignificant;
    }

    public String getDescription() {
        return "Layout";
    }

    private Map<EntityID, Point> getCenters() throws GraphStoreException {
        GraphLayoutReader layoutReader = this.getLayoutReader();
        HashMap<EntityID, Point> centers = new HashMap<EntityID, Point>();
        for (Map.Entry entry : layoutReader.getAllCenters().entrySet()) {
            EntityID entityID = (EntityID)entry.getKey();
            Point center = (Point)entry.getValue();
            if (center == null) continue;
            centers.put(entityID, center);
        }
        return centers;
    }

    private Map<LinkID, List<Point>> getBends() throws GraphStoreException {
        GraphLayoutReader layoutReader = this.getLayoutReader();
        HashMap<LinkID, List<Point>> paths = new HashMap<LinkID, List<Point>>();
        for (Map.Entry entry : layoutReader.getAllPaths().entrySet()) {
            LinkID linkID = (LinkID)entry.getKey();
            List path = (List)entry.getValue();
            if (path == null) continue;
            paths.put(linkID, path);
        }
        return paths;
    }

    private void setCenters(Map<EntityID, Point> centers) throws GraphStoreException {
        if (centers != null) {
            this.getLayoutWriter().setCenters(centers);
        }
    }

    private void setPaths(Map<LinkID, List<Point>> bends) throws GraphStoreException {
        if (bends != null) {
            this.getLayoutWriter().setPaths(bends);
        }
    }

    private GraphLayoutStore getLayoutStore() throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this.getGraphID());
        return graphStore.getGraphLayoutStore();
    }

    private GraphLayoutReader getLayoutReader() throws GraphStoreException {
        GraphLayoutStore layoutStore = this.getLayoutStore();
        return layoutStore.getLayoutReader();
    }

    private GraphLayoutWriter getLayoutWriter() throws GraphStoreException {
        GraphLayoutStore layoutStore = this.getLayoutStore();
        return layoutStore.getLayoutWriter();
    }
}

