/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.paterva.maltego.customicons.imex.SelectableIcon;
import com.paterva.maltego.imgfactory.icons.IconExistInfo;
import com.paterva.maltego.importexport.ConfigNode;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class IconNode
extends ConfigNode {
    private boolean _isCheckEnabled = true;

    public IconNode(SelectableIcon icon, IconExistInfo existInfo) {
        this(icon, new InstanceContent(), existInfo);
    }

    private IconNode(SelectableIcon icon, InstanceContent content, IconExistInfo existInfo) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.addLookups(content, icon);
        String displayName = icon.getIconName();
        if (existInfo != null && existInfo.exist(icon.getIconCategory(), icon.getIconName())) {
            if (existInfo.isBuiltIn(icon.getIconCategory(), icon.getIconName())) {
                displayName = "<built-in> " + displayName;
                this._isCheckEnabled = false;
            } else {
                displayName = "<exist> " + displayName;
            }
        }
        this.setDisplayName(displayName);
        this.setShortDescription(icon.getIcon(IconSize.TINY).getFileObject().getNameExt());
        this.setSelectedNonRecursive(icon.isSelected());
    }

    public boolean isCheckEnabled() {
        return this._isCheckEnabled;
    }

    private void addLookups(InstanceContent content, SelectableIcon icon) {
        content.add((Object)icon);
        content.add((Object)this);
    }

    public final void setSelectedNonRecursive(Boolean selected) {
        if (!this.isSelected().equals(selected)) {
            super.setSelectedNonRecursive(selected);
            SelectableIcon icon = (SelectableIcon)this.getLookup().lookup(SelectableIcon.class);
            icon.setSelected(selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getIcon(int type) {
        int size = this.getSize(type);
        SelectableIcon icon = (SelectableIcon)this.getLookup().lookup(SelectableIcon.class);
        FileObject fileObject = icon.getIcon(IconSize.getSize((int)size)).getFileObject();
        InputStream is = null;
        try {
            is = fileObject.getInputStream();
            BufferedImage img = ImageIO.read(is);
            if (img != null && ImageUtils.isSVGFile((FileObject)fileObject)) {
                img = ImageUtils.smartSize((BufferedImage)img, (double)size);
            }
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private int getSize(int type) {
        if (type == 1 || type == 3) {
            return 16;
        }
        return 32;
    }
}

