/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.runtime;

import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.runtime.MachineRunner;
import com.paterva.maltego.automation.runtime.MachineRuntime;
import com.paterva.maltego.automation.runtime.TimeKeeper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class DefaultTimeKeeper
extends TimeKeeper {
    private Map<MachineRuntime, AutomationContext> _machines = new HashMap<MachineRuntime, AutomationContext>();
    private Timer _timer;
    private boolean _isRunning = false;
    private static final int PERIOD = 1000;
    private boolean _busy = false;
    private final String _lock = new String();

    @Override
    public void start(MachineRuntime machine, AutomationContext ctx) {
        this._machines.put(machine, ctx);
        if (!this._isRunning) {
            this._isRunning = true;
            this._timer = new Timer(true);
            this._timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        DefaultTimeKeeper.this.onTimer();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, 1000L, 1000L);
        }
    }

    @Override
    public void stop(MachineRuntime machine) {
        this._machines.remove(machine);
        if (this._machines.isEmpty() && this._isRunning) {
            this._timer.cancel();
            this._timer = null;
            this._isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTimer() {
        if (this._busy) {
            return;
        }
        String string = this._lock;
        synchronized (string) {
            try {
                if (!this._busy) {
                    this._busy = true;
                }
                this.doTick();
            }
            finally {
                this._busy = false;
            }
        }
    }

    private void doTick() {
        LinkedList<TimerMachineTuple> events = new LinkedList<TimerMachineTuple>();
        LinkedList<TickTuple> waiting = new LinkedList<TickTuple>();
        for (Map.Entry<MachineRuntime, AutomationContext> entry : this._machines.entrySet()) {
            int newTick;
            if (entry.getKey().getTimerInterval() <= 0) continue;
            Integer tickCount = (Integer)entry.getValue().getGlobal("timer");
            if (tickCount == null) {
                newTick = 0;
            } else {
                newTick = tickCount + 1;
                if (newTick >= entry.getKey().getTimerInterval()) {
                    newTick = 0;
                    events.add(new TimerMachineTuple("timer", entry.getKey()));
                } else if (entry.getKey().isWaiting()) {
                    int tick = entry.getKey().getTimerInterval() - newTick;
                    waiting.add(new TickTuple("timer", entry.getKey(), tick));
                }
            }
            entry.getValue().setGlobal("timer", newTick);
        }
        for (TimerMachineTuple tuple : events) {
            this.handleTimerEvent(tuple.timer, tuple.machine);
        }
        this.fireWaitingEvents(waiting);
    }

    private void handleTimerEvent(final Object timer, final MachineRuntime machine) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MachineRunner.getDefault().handleEvent(machine, timer, null);
            }
        });
    }

    private void fireWaitingEvents(final List<TickTuple> timers) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (TickTuple tuple : timers) {
                    MachineRunner.getDefault().handleEvent(tuple.machine, "waiting-tick", tuple.tick);
                }
            }
        });
    }

    private class TickTuple {
        public Object timer;
        public MachineRuntime machine;
        public int tick;

        public TickTuple(Object timer, MachineRuntime machine, int tick) {
            this.timer = timer;
            this.machine = machine;
            this.tick = tick;
        }
    }

    private class TimerMachineTuple {
        public Object timer;
        public MachineRuntime machine;

        public TimerMachineTuple(Object timer, MachineRuntime machine) {
            this.timer = timer;
            this.machine = machine;
        }
    }
}

