/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chapter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.query.part.EntitiesDataQuery;
import com.paterva.maltego.graph.store.query.part.EntityDataQuery;
import com.paterva.maltego.graph.store.query.part.PartDataQuery;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.reporting.pdf.PdfReportCommonGenerator;
import com.paterva.maltego.reporting.pdf.ReportGenerator;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.progress.ProgressController;
import com.paterva.maltego.util.ui.progress.ProgressDescriptor;
import com.paterva.maltego.util.ui.progress.ProgressDialogFactory;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import yguard.A.A.D;
import yguard.A.J.SA;
import yguard.A.J.U;

public class PdfReportFasterGenerator
extends PdfReportCommonGenerator
implements ReportGenerator {
    private static final Logger LOG = Logger.getLogger(PdfReportFasterGenerator.class.getName());

    public PdfReportFasterGenerator(boolean generateTitlePage, boolean generateFooter) {
        super(generateTitlePage, generateFooter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean generateReport(File outFile, U view, final boolean wholeGraph, final boolean includeGraphImage, final boolean includeEntityImages, final boolean includeDisplayInfoImages, final boolean includeEmptyProperties, final boolean includeHiddenProperties, final boolean includeUserProperties, final boolean anonymousReport) {
        this._success = false;
        this._warnings = new StringBuilder();
        Boolean isOptimizationsEnabled = null;
        EntityPainter entityPainter = null;
        try {
            this._view = view;
            this._chapter = 1;
            this._footerImage = null;
            this._tempFiles = new ArrayList();
            this._imagesByType = new HashMap();
            this._imagesByObject = new HashMap();
            SA graph2D = this._view.getGraph2D();
            final GraphID graphID = GraphIDProvider.forGraph((SA)graph2D);
            entityPainter = EntityPainterSettings.getDefault().getEntityPainter(graphID);
            this.factory = EntityImageFactory.forGraph((GraphID)graphID);
            isOptimizationsEnabled = entityPainter.isOptimizationsEnabled();
            entityPainter.setOptimizationsEnabled(false);
            this._doc = new Document(PageSize.A4, 50.0f, 50.0f, 50.0f, 80.0f);
            try {
                this._writer = PdfWriter.getInstance((Document)this._doc, (OutputStream)new FileOutputStream(outFile));
            }
            catch (FileNotFoundException ex) {
                String msg = String.format("Failed to create %s\n%s", outFile.getAbsolutePath(), ex.getMessage());
                LOG.info(msg);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                throw ex;
            }
            this._writer.setPageEvent((PdfPageEvent)new PdfReportCommonGenerator.EndPage(includeGraphImage));
            this._doc.open();
            this._registry = EntityRegistry.forGraph((D)graph2D);
            GraphStructureReader structureReader = GraphStoreRegistry.getDefault().forGraphID(graphID).getGraphStructureStore().getStructureReader();
            final GraphDataStoreReader dataStoreReader = GraphStoreRegistry.getDefault().forGraphID(graphID).getGraphDataStore().getDataStoreReader();
            final int linkCount = structureReader.getLinkCount();
            final ArrayList entities = new ArrayList(structureReader.getEntities());
            this._progress = 1;
            this._progressTotal = includeEntityImages ? 4 * entities.size() + 7 : 3 * entities.size() + 7;
            this._progressOffset = entities.size() / 3;
            ProgressDescriptor progress = ProgressDialogFactory.createProgressDialog((String)"Generating report", (boolean)true);
            final ProgressController controller = progress.getController();
            Component component = progress.getGUIComponent();
            Thread process = new Thread(new Runnable(){

                @Override
                public void run() {
                    PdfReportFasterGenerator.this._progress = 1;
                    controller.start(PdfReportFasterGenerator.this._progressTotal);
                    try {
                        if (PdfReportFasterGenerator.this._generateTitlePage && !controller.isCanceled()) {
                            PdfReportFasterGenerator.this.createTitlePage(controller);
                        }
                        Map entitiesMap = PdfReportFasterGenerator.this.loadEntities(entities, dataStoreReader, controller);
                        ArrayList entitiesList = new ArrayList(entitiesMap.values());
                        if (includeEntityImages && !controller.isCanceled()) {
                            PdfReportFasterGenerator.this.loadEntityImages(graphID, entitiesList, controller);
                        }
                        if (includeGraphImage && !controller.isCanceled()) {
                            PdfReportFasterGenerator.this.createGraphImage(controller, wholeGraph);
                        }
                        if (!controller.isCanceled()) {
                            PdfReportFasterGenerator.this.createRankTables(entitiesList, controller, linkCount);
                        }
                        if (!controller.isCanceled()) {
                            PdfReportFasterGenerator.this.createTypeTables(entitiesList, controller);
                        }
                        if (!controller.isCanceled()) {
                            PdfReportFasterGenerator.this.createEntityTables(entitiesMap, entitiesList, controller, includeEntityImages, includeDisplayInfoImages, includeEmptyProperties, includeHiddenProperties, includeUserProperties, anonymousReport);
                        }
                        if (!controller.isCanceled() && PdfReportFasterGenerator.this._progress != PdfReportFasterGenerator.this._progressTotal) {
                            System.out.println("graphEntityIDCount: " + entities.size());
                            String msg = String.format("WARNING - Progress incorrectly calculated (%d vs %d)", PdfReportFasterGenerator.this._progress, PdfReportFasterGenerator.this._progressTotal);
                            System.out.println(msg);
                        }
                        PdfReportFasterGenerator.this._success = !controller.isCanceled();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    controller.finish();
                }
            }, "Report Generator");
            process.start();
            component.setVisible(true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (BadElementException ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)ex, (Object)"Failed to generate report: Cannot create element."));
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (DocumentException ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)ex, (Object)"Failed to generate report: Invalid document operation."));
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                if (this._doc != null) {
                    this._doc.close();
                }
                if (this._writer != null) {
                    this._writer.close();
                }
                if (this._tempFiles != null) {
                    for (File tempFile : this._tempFiles) {
                        if (tempFile == null) continue;
                        tempFile.delete();
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (isOptimizationsEnabled != null && entityPainter != null) {
                    entityPainter.setOptimizationsEnabled(isOptimizationsEnabled.booleanValue());
                }
            }
        }
        String warnings = this._warnings.toString();
        if (this._success && !warnings.isEmpty()) {
            warnings = "The report was generated with the following warnings:\n\n" + warnings;
            LOG.info(warnings);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)warnings, 2));
        }
        return this._success;
    }

    private Map<EntityID, MaltegoEntity> loadEntities(List<EntityID> entities, GraphDataStoreReader dataStoreReader, ProgressController controller) throws GraphStoreException {
        controller.progress("Loading entities", this._progress);
        EntitiesDataQuery query = new EntitiesDataQuery();
        query.setIDs(new HashSet<EntityID>(entities));
        EntityDataQuery dataQuery = new EntityDataQuery();
        dataQuery.setAllProperties(true);
        dataQuery.setAllSections(true);
        query.setPartDataQuery((PartDataQuery)dataQuery);
        Map entitiesMap = dataStoreReader.getEntities(query);
        return entitiesMap;
    }

    private void createRankTables(List<MaltegoEntity> entities, ProgressController controller, int linkCount) throws DocumentException {
        controller.progress("Top 10 Entities", this._progress++);
        Paragraph title = new Paragraph("Top 10 Entities", CHAPTER_TITLE_FONT);
        Chapter chapter = new Chapter(title, this._chapter++);
        chapter.add((Element)this.createSummaryTable(this._view.getGraph2D(), entities.size(), linkCount));
        try {
            if (!controller.isCanceled()) {
                this._progress += this._progressOffset / 3;
                controller.progress("Top 10 Entities: Ranked by Incoming Links", this._progress);
                chapter.add((Element)this.createRankTable(entities, PdfReportCommonGenerator.Rank.RANK_IN_LINKS, 10, controller));
            }
            if (!controller.isCanceled()) {
                this._progress += this._progressOffset / 3;
                controller.progress("Top 10 Entities: Ranked by Outgoing Links", this._progress);
                chapter.add((Element)this.createRankTable(entities, PdfReportCommonGenerator.Rank.RANK_OUT_LINKS, 10, controller));
            }
            if (!controller.isCanceled()) {
                this._progress += this._progressOffset / 3;
                controller.progress("Top 10 Entities: Ranked by Total Links", this._progress);
                chapter.add((Element)this.createRankTable(entities, PdfReportCommonGenerator.Rank.RANK_TOTAL_LINKS, 10, controller));
            }
        }
        catch (GraphStoreException ex) {
            throw new DocumentException((Exception)((Object)ex));
        }
        this._doc.add((Element)chapter);
    }

    private void createTypeTables(List<MaltegoEntity> entities, ProgressController controller) throws DocumentException, GraphStoreException {
        controller.progress("Entities by Type", this._progress++);
        Paragraph title = new Paragraph("Entities by Type", CHAPTER_TITLE_FONT);
        Chapter chapter = new Chapter(title, this._chapter++);
        HashMap entityTypes = new HashMap();
        for (MaltegoEntity entity : entities) {
            Object specIdentifier;
            controller.progress(this._progress++);
            MaltegoEntitySpec entitySpec = this.getMaltegoEntitySpec(entity);
            String entityName = InheritanceHelper.getDisplayString((SpecRegistry)this._registry, (TypedPropertyBag)entity);
            Object object = specIdentifier = entitySpec != null ? entitySpec : entity.getTypeName();
            if (!entityTypes.containsKey(specIdentifier)) {
                entityTypes.put((MaltegoEntitySpec)specIdentifier, new ArrayList());
            }
            ((List)entityTypes.get(specIdentifier)).add(entityName);
        }
        ArrayList keys = new ArrayList(entityTypes.keySet());
        Collections.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object n1, Object n2) {
                String v1 = this.getSortingDisplayText(n1);
                String v2 = this.getSortingDisplayText(n2);
                return v1.compareTo(v2);
            }

            private String getSortingDisplayText(Object n) {
                String v = n instanceof String ? (String)n : ((MaltegoEntitySpec)n).getDisplayNamePlural();
                return v;
            }
        });
        for (Object key : keys) {
            List subTypes = (List)entityTypes.get(key);
            Collections.sort(subTypes);
            chapter.add((Element)this.createEntityTypeTable(key, subTypes));
        }
        this._doc.add((Element)chapter);
    }

    private void triggerImageDownload(List<MaltegoEntity> entities, int startIndex, int endIndex) throws GraphStoreException {
        for (int i = startIndex; i <= endIndex; ++i) {
            this.factory.getImage(entities.get(i), null);
        }
    }

    private void loadEntityImages(GraphID graphID, List<MaltegoEntity> entities, ProgressController controller) throws IOException, BadElementException {
        int iconSize = (int)ITEXT_STYLE.getFontSize(false) + 2;
        int maxThreadCount = 10;
        int markerTrigger = 6;
        int nodesTotal = entities.size();
        int startIndex = 0;
        int marker = 0;
        int endIndex = (maxThreadCount < nodesTotal ? maxThreadCount : nodesTotal) - 1;
        this.triggerImageDownload(entities, startIndex, endIndex);
        String titleStr = "Loading Entity Images";
        controller.progress(titleStr, this._progress++);
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        int num = 0;
        HashMap<String, Integer> entityTypesCount = new HashMap<String, Integer>();
        for (MaltegoEntity entity : entities) {
            if (controller.isCanceled()) {
                return;
            }
            ++num;
            ++marker;
            boolean forceUseTypeImage = false;
            if (forceUseTypeImage) {
                String typeName = entity.getTypeName();
                Integer typeCount = (Integer)entityTypesCount.get(typeName);
                if (typeCount == null) {
                    typeCount = 0;
                } else {
                    Integer n = typeCount;
                    Integer n2 = typeCount = Integer.valueOf(typeCount + 1);
                }
                entityTypesCount.put(typeName, typeCount);
                if (typeCount < 100) {
                    forceUseTypeImage = false;
                }
            }
            String progressMsg = String.format("%s%s (%d/%d)", titleStr, forceUseTypeImage ? " - type images" : "", num, nodesTotal);
            controller.progress(progressMsg, this._progress++);
            if (marker == maxThreadCount) {
                marker = 0;
            } else if (marker == markerTrigger) {
                startIndex = endIndex + 1;
                if ((endIndex = startIndex + maxThreadCount) > nodesTotal) {
                    endIndex = nodesTotal;
                }
                if (startIndex < --endIndex) {
                    this.triggerImageDownload(entities, startIndex, endIndex);
                }
            }
            try {
                EntityID graphEntityID = (EntityID)entity.getID();
                if (view.getModelViewMappings().isOnlyViewEntity(graphEntityID)) continue;
                Image entityImage = this.getEntityImage(forceUseTypeImage, entity, iconSize, iconSize);
                this._entityImages.put(graphEntityID, entityImage);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void createEntityTables(Map<EntityID, MaltegoEntity> entitiesMap, List<MaltegoEntity> entities, ProgressController controller, boolean includeEntityImages, boolean includeDisplayInfoImages, boolean includeEmptyProperties, boolean includeHiddenProperties, boolean includeUserProperties, boolean anonymousReport) throws IOException, DocumentException {
        GraphID graphID = GraphIDProvider.forGraph((SA)this._view.getGraph2D());
        final GraphStructureReader structureReader = GraphStoreRegistry.getDefault().forGraphID(graphID).getGraphStructureStore().getStructureReader();
        Collections.sort(entities, new Comparator<MaltegoEntity>(){

            @Override
            public int compare(MaltegoEntity e1, MaltegoEntity e2) {
                EntityID n1 = (EntityID)e1.getID();
                EntityID n2 = (EntityID)e2.getID();
                try {
                    return structureReader.getLinkCount(n2) - structureReader.getLinkCount(n1);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return 0;
                }
            }
        });
        Map incomingLinksMap = structureReader.getIncoming(entitiesMap.keySet());
        Map outgoingLinksMap = structureReader.getOutgoing(entitiesMap.keySet());
        String titleStr = "Entity Details";
        controller.progress(titleStr, this._progress++);
        Paragraph title = new Paragraph(titleStr, CHAPTER_TITLE_FONT);
        Chapter chapter = new Chapter(title, this._chapter++);
        int num = 0;
        int nodesTotal = entities.size();
        for (MaltegoEntity entity : entities) {
            if (controller.isCanceled()) {
                return;
            }
            String progressMsg = String.format("%s (%d/%d)", titleStr, ++num, nodesTotal);
            controller.progress(progressMsg, this._progress++);
            PdfPTable outerTable = new PdfPTable(1);
            outerTable.setSpacingBefore(10.0f);
            outerTable.setSpacingAfter(10.0f);
            outerTable.setKeepTogether(false);
            outerTable.setExtendLastRow(false);
            outerTable.setWidthPercentage(100.0f);
            outerTable.getDefaultCell().setPadding(3.0f);
            outerTable.getDefaultCell().setBorderColor(Color.LIGHT_GRAY);
            outerTable.getDefaultCell().setBorder(13);
            outerTable.addCell(this.createNodeHeaderTable(entity, includeEntityImages, anonymousReport));
            outerTable.getDefaultCell().setBorder(12);
            outerTable.addCell(this.createNodePropertiesTable(entity, includeEmptyProperties, includeHiddenProperties, includeUserProperties));
            DisplayInformationCollection displayInformation = entity.getDisplayInformation();
            if (displayInformation != null) {
                for (DisplayInformation displayInfo : displayInformation) {
                    outerTable.getDefaultCell().setBorder(12);
                    outerTable.addCell(this.createNodeDisplayInfoTable(displayInfo, includeDisplayInfoImages, progressMsg, controller));
                }
            }
            outerTable.getDefaultCell().setBorder(14);
            EntityID entityID = (EntityID)entity.getID();
            outerTable.addCell(this.createNodeLinksTable((Set)incomingLinksMap.get(entityID), (Set)outgoingLinksMap.get(entityID), entitiesMap, includeEntityImages));
            chapter.add((Element)outerTable);
        }
        controller.progress(titleStr + " (Appending To Document)", this._progress);
        this._doc.add((Element)chapter);
        this._progress += this._progressOffset;
        controller.progress(titleStr + " (Finalizing)", this._progress++);
    }

    private PdfPTable createRankTable(List<MaltegoEntity> entities, final PdfReportCommonGenerator.Rank rank, int topCount, ProgressController controller) throws BadElementException, DocumentException, GraphStoreException {
        String rankStr;
        FontSelector fs = ITEXT_STYLE.getFontSelector("Helvetica", 12.0f, 1, Color.DARK_GRAY);
        GraphID graphID = GraphIDProvider.forGraph((SA)this._view.getGraph2D());
        final GraphStructureReader structureReader = GraphStoreRegistry.getDefault().forGraphID(graphID).getGraphStructureStore().getStructureReader();
        Collections.sort(entities, new Comparator<MaltegoEntity>(){

            @Override
            public int compare(MaltegoEntity e1, MaltegoEntity e2) {
                try {
                    EntityID n1 = (EntityID)e1.getID();
                    EntityID n2 = (EntityID)e2.getID();
                    switch (rank) {
                        case RANK_IN_LINKS: {
                            return structureReader.getIncomingLinkCount(n2) - structureReader.getIncomingLinkCount(n1);
                        }
                        case RANK_OUT_LINKS: {
                            return structureReader.getOutgoingLinkCount(n2) - structureReader.getOutgoingLinkCount(n1);
                        }
                        case RANK_TOTAL_LINKS: {
                            return structureReader.getLinkCount(n2) - structureReader.getLinkCount(n1);
                        }
                    }
                    return e2.getWeight() - e1.getWeight();
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return 0;
                }
            }
        });
        PdfPTable table = new PdfPTable(4);
        table.setSpacingBefore(20.0f);
        table.setWidthPercentage(100.0f);
        table.setWidths(new float[]{0.8f, 3.0f, 4.5f, 1.7f});
        PdfPCell titleCell = new PdfPCell();
        titleCell.setColspan(4);
        titleCell.setHorizontalAlignment(1);
        titleCell.setBorder(0);
        titleCell.setPaddingBottom(5.0f);
        switch (rank) {
            case RANK_IN_LINKS: {
                titleCell.setPhrase((Phrase)new Paragraph(fs.process("Ranked by Incoming Links")));
                break;
            }
            case RANK_OUT_LINKS: {
                titleCell.setPhrase((Phrase)new Paragraph(fs.process("Ranked by Outgoing Links")));
                break;
            }
            case RANK_TOTAL_LINKS: {
                titleCell.setPhrase((Phrase)new Paragraph(fs.process("Ranked by Total Links")));
                break;
            }
            default: {
                titleCell.setPhrase((Phrase)new Paragraph(fs.process("Ranked by Weight")));
            }
        }
        table.addCell(titleCell);
        table.addCell(ITEXT_STYLE.getCell("Rank", true));
        table.addCell(ITEXT_STYLE.getCell("Type", true));
        table.addCell(ITEXT_STYLE.getCell("Value", true));
        switch (rank) {
            case RANK_IN_LINKS: {
                rankStr = "Incoming links";
                break;
            }
            case RANK_OUT_LINKS: {
                rankStr = "Outgoing links";
                break;
            }
            case RANK_TOTAL_LINKS: {
                rankStr = "Total links";
                break;
            }
            default: {
                rankStr = "Weight";
            }
        }
        table.addCell(ITEXT_STYLE.getCell(rankStr, true));
        int rankNum = 1;
        for (MaltegoEntity entity : entities) {
            int value;
            EntityID graphEntityID = (EntityID)entity.getID();
            table.addCell(ITEXT_STYLE.getCell(rankNum++, false));
            MaltegoEntitySpec spec = this.getMaltegoEntitySpec(entity);
            String typeDisplayName = spec != null ? spec.getDisplayName() : entity.getTypeName();
            PdfPCell cell = ITEXT_STYLE.getCell(typeDisplayName, false);
            cell.setBackgroundColor(this.getEntityTypeColor(spec));
            table.addCell(cell);
            table.addCell(ITEXT_STYLE.getCell(InheritanceHelper.getDisplayString((SpecRegistry)this._registry, (TypedPropertyBag)entity), false));
            switch (rank) {
                case RANK_IN_LINKS: {
                    value = structureReader.getIncomingLinkCount(graphEntityID);
                    break;
                }
                case RANK_OUT_LINKS: {
                    value = structureReader.getOutgoingLinkCount(graphEntityID);
                    break;
                }
                case RANK_TOTAL_LINKS: {
                    value = structureReader.getLinkCount(graphEntityID);
                    break;
                }
                default: {
                    value = entity.getWeight();
                }
            }
            table.addCell(ITEXT_STYLE.getCell(value, false));
            if (rankNum <= topCount) continue;
            break;
        }
        return table;
    }

    private PdfPTable createNodePropertiesTable(MaltegoEntity maltegoEntity, boolean includeEmptyProperties, boolean includeHiddenProperties, boolean includeUserProperties) throws DocumentException, GraphStoreException {
        PdfPTable table = new PdfPTable(3);
        table.setWidthPercentage(95.0f);
        table.setWidths(new float[]{0.05f, 0.3f, 0.65f});
        PropertyDescriptorCollection properties = maltegoEntity.getProperties();
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        table.addCell(cell);
        table.addCell(ITEXT_STYLE.getCell("Weight", false));
        table.addCell(ITEXT_STYLE.getCell(maltegoEntity.getWeight(), false));
        for (PropertyDescriptor property : properties) {
            String propertyName = property.getName();
            String propertyDisplayName = property.getDisplayName();
            Object value = maltegoEntity.getValue(property);
            if (propertyName.equals("maltego.fixed.type") || propertyName.equals("maltego.calculated.value") || (!includeHiddenProperties || !property.isHidden()) && property.isHidden() || !includeUserProperties && (propertyName.equals("maltego.date.created") || propertyName.equals("maltego.date.modified") || propertyName.equals("maltego.user.created") || propertyName.equals("maltego.user.modified"))) continue;
            String propertyValue = "";
            if (value != null) {
                StringBuilder sb = new StringBuilder();
                if (value.getClass().isArray()) {
                    sb.append('[');
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        sb.append(Array.get(value, i));
                        if (i + 1 >= length) continue;
                        sb.append(", ");
                    }
                    sb.append(']');
                } else {
                    sb.append(value.toString());
                }
                propertyValue = sb.toString();
            }
            if (!includeEmptyProperties && StringUtilities.isNullOrEmpty((String)propertyValue)) continue;
            cell = new PdfPCell();
            cell.setBorder(0);
            table.addCell(cell);
            table.addCell(ITEXT_STYLE.getCell(propertyDisplayName, false));
            table.addCell(ITEXT_STYLE.getCell(propertyValue, false));
        }
        return table;
    }

    private void sortByEntityName(final Map<EntityID, MaltegoEntity> entitiesMap, List<LinkID> links, final GraphStructureReader structureReader, final PdfReportCommonGenerator.SourceTarget sourceTarget) {
        Collections.sort(links, new Comparator<LinkID>(){

            @Override
            public int compare(LinkID o1, LinkID o2) {
                try {
                    EntityID e2;
                    EntityID e1;
                    switch (sourceTarget) {
                        case SOURCE: {
                            e1 = structureReader.getSource(o1);
                            e2 = structureReader.getSource(o2);
                            break;
                        }
                        case TARGET: {
                            e1 = structureReader.getTarget(o1);
                            e2 = structureReader.getTarget(o2);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported link target");
                        }
                    }
                    MaltegoEntity me1 = (MaltegoEntity)entitiesMap.get(e1);
                    MaltegoEntitySpec spec1 = PdfReportFasterGenerator.this.getMaltegoEntitySpec(me1);
                    MaltegoEntity me2 = (MaltegoEntity)entitiesMap.get(e2);
                    MaltegoEntitySpec spec2 = PdfReportFasterGenerator.this.getMaltegoEntitySpec(me2);
                    String type1 = spec1 != null ? spec1.getDisplayName() : me1.getTypeName();
                    String type2 = spec2 != null ? spec2.getDisplayName() : me2.getTypeName();
                    return type1.compareTo(type2);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return 0;
                }
            }
        });
    }

    private void addOrCreate(Map<String, List<MaltegoEntity>> sortedTypeNamesToEntities, MaltegoEntity entity) throws GraphStoreException {
        MaltegoEntitySpec spec = this.getMaltegoEntitySpec(entity);
        String typeDisplayName = spec != null ? spec.getDisplayName() : entity.getTypeName();
        List<MaltegoEntity> list = sortedTypeNamesToEntities.get(typeDisplayName);
        if (list == null) {
            list = new ArrayList<MaltegoEntity>();
            sortedTypeNamesToEntities.put(typeDisplayName, list);
        }
        list.add(entity);
    }

    private void sortList(List<MaltegoEntity> entityList) {
        Collections.sort(entityList, new Comparator<MaltegoEntity>(){

            @Override
            public int compare(MaltegoEntity e1, MaltegoEntity e2) {
                String t1 = InheritanceHelper.getDisplayString((SpecRegistry)PdfReportFasterGenerator.this._registry, (TypedPropertyBag)e1);
                String t2 = InheritanceHelper.getDisplayString((SpecRegistry)PdfReportFasterGenerator.this._registry, (TypedPropertyBag)e2);
                return t1.compareTo(t2);
            }
        });
    }

    private PdfPTable createNodeLinksTable(Set<LinkID> incomingLinks, Set<LinkID> outgoingLinks, Map<EntityID, MaltegoEntity> entitiesMap, boolean includeEntityImages) throws DocumentException, IOException {
        int iconSize = (int)ITEXT_STYLE.getFontSize(false) + 2;
        if (incomingLinks.isEmpty() && outgoingLinks.isEmpty()) {
            return null;
        }
        GraphID graphID = GraphIDProvider.forGraph((SA)this._view.getGraph2D());
        GraphStructureReader structureReader = GraphStoreRegistry.getDefault().forGraphID(graphID).getGraphStructureStore().getStructureReader();
        PdfPTable table = new PdfPTable(3);
        table.setSpacingBefore(5.0f);
        table.setWidthPercentage(100.0f);
        table.setWidths(new float[]{0.05f, 0.4f, 0.55f});
        table.setHorizontalAlignment(2);
        ArrayList<LinkID> incomingModelLinks = new ArrayList<LinkID>(incomingLinks);
        this.sortByEntityName(entitiesMap, incomingModelLinks, structureReader, PdfReportCommonGenerator.SourceTarget.SOURCE);
        if (!incomingModelLinks.isEmpty()) {
            PdfPCell cell = ITEXT_STYLE.getCell("Incoming (" + incomingModelLinks.size() + ")", true);
            cell.setColspan(3);
            table.addCell(cell);
            LinkedHashMap<String, List<MaltegoEntity>> sortedTypeNamesToEntities = new LinkedHashMap<String, List<MaltegoEntity>>();
            for (LinkID incomingModelLink : incomingModelLinks) {
                EntityID sourceEntityID = structureReader.getSource(incomingModelLink);
                MaltegoEntity sourceEntity = entitiesMap.get(sourceEntityID);
                this.addOrCreate(sortedTypeNamesToEntities, sourceEntity);
            }
            this.addEntityDetailSortedDataCells(sortedTypeNamesToEntities, includeEntityImages, iconSize, table);
        }
        ArrayList<LinkID> outgoingModelLinks = new ArrayList<LinkID>(outgoingLinks);
        this.sortByEntityName(entitiesMap, outgoingModelLinks, structureReader, PdfReportCommonGenerator.SourceTarget.TARGET);
        if (!outgoingModelLinks.isEmpty()) {
            PdfPCell cell = ITEXT_STYLE.getCell("Outgoing (" + outgoingModelLinks.size() + ")", true);
            cell.setColspan(3);
            table.addCell(cell);
            LinkedHashMap<String, List<MaltegoEntity>> sortedTypeNamesToEntities = new LinkedHashMap<String, List<MaltegoEntity>>();
            for (LinkID outgoingModelLink : outgoingModelLinks) {
                EntityID targetEntityID = structureReader.getTarget(outgoingModelLink);
                MaltegoEntity targetEntity = entitiesMap.get(targetEntityID);
                this.addOrCreate(sortedTypeNamesToEntities, targetEntity);
            }
            this.addEntityDetailSortedDataCells(sortedTypeNamesToEntities, includeEntityImages, iconSize, table);
        }
        return table;
    }

    private void addEntityDetailSortedDataCells(Map<String, List<MaltegoEntity>> sortedTypeNamesToEntities, boolean includeEntityImages, int iconSize, PdfPTable table) throws IOException, BadElementException {
        for (Map.Entry<String, List<MaltegoEntity>> entry : sortedTypeNamesToEntities.entrySet()) {
            List<MaltegoEntity> entityList = entry.getValue();
            this.sortList(entityList);
            for (MaltegoEntity entity : entityList) {
                PdfPCell cell;
                String typeDisplayName;
                MaltegoEntitySpec spec = this.getMaltegoEntitySpec(entity);
                String string = typeDisplayName = spec != null ? spec.getDisplayName() : entity.getTypeName();
                if (includeEntityImages) {
                    String typeName = spec != null ? spec.getTypeName() : entity.getTypeName();
                    Image img = (Image)this._entityImages.get(entity.getID());
                    if (img == null) {
                        img = (Image)this._imagesByType.get(typeName);
                    }
                    img.scaleToFit((float)iconSize, (float)iconSize);
                    cell = ITEXT_STYLE.getCell(img, false);
                    cell.setHorizontalAlignment(1);
                    table.addCell(cell);
                } else {
                    cell = ITEXT_STYLE.getCell("", true);
                    table.addCell(cell);
                }
                cell = ITEXT_STYLE.getCell(typeDisplayName, false);
                cell.setBackgroundColor(this.getEntityTypeColor(spec));
                table.addCell(cell);
                table.addCell(ITEXT_STYLE.getCell(InheritanceHelper.getDisplayString((SpecRegistry)this._registry, (TypedPropertyBag)entity), false));
            }
        }
    }

    private Image getEntityImage(boolean forceUseTypeImage, MaltegoEntity entity, int width, int height) throws IOException, BadElementException {
        java.awt.Image entityImage;
        GraphID graphID = GraphIDProvider.forGraph((SA)this._view.getGraph2D());
        Object imageKey = InheritanceHelper.getImageKey((EntityRegistry)this._registry, (MaltegoEntity)entity).orElse(null);
        Image image = null;
        boolean useTypeImage = false;
        if (forceUseTypeImage || imageKey == null) {
            useTypeImage = true;
        } else if (this._imagesByObject.containsKey(imageKey)) {
            image = (Image)this._imagesByObject.get(imageKey);
        } else {
            entityImage = ImageFactory.getDefault().getImage(graphID, imageKey, -1, -1, null);
            if (entityImage == null) {
                if (imageKey instanceof FastURL || imageKey instanceof String && FastURL.isFastURL((String)((String)imageKey))) {
                    image = this.getBrokenImage();
                    if (image == null) {
                        useTypeImage = true;
                    }
                } else {
                    useTypeImage = true;
                }
            } else {
                image = this.javaToPdfImage(entityImage);
                this._imagesByObject.put(imageKey, image);
            }
        }
        if (useTypeImage) {
            if (this._imagesByType.containsKey(entity.getTypeName())) {
                image = (Image)this._imagesByType.get(entity.getTypeName());
            } else {
                entityImage = this.factory.getTypeImage(entity.getTypeName(), -1, -1, null);
                image = this.javaToPdfImage(entityImage);
                this._imagesByType.put(entity.getTypeName(), image);
            }
        }
        if (image != null) {
            image.scaleToFit((float)width, (float)height);
        }
        return image;
    }
}

