/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.format;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.table.TableIO;
import com.paterva.maltego.graph.table.format.EntityTableFormatter;
import com.paterva.maltego.graph.table.format.PropertyFlatMapFormat;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.openide.util.Exceptions;

public class GroupEntityTypeFormat
extends EntityTableFormatter {
    MaltegoEntity lastEntity;
    List<String> groupDisplayHeader;
    List<String> groupTypeHeader;
    LinkedHashSet<PropertyDescriptor> groupProperties;

    public GroupEntityTypeFormat(TableIO table) {
        super(table);
    }

    @Override
    public void addEntity(MaltegoEntity entity) {
        this.updateGroupHeader(entity);
        ArrayList<String> row = new ArrayList<String>(this.groupProperties.size() + 1);
        row.add(((EntityID)entity.getID()).toString());
        for (PropertyDescriptor property : this.groupProperties) {
            Object value = entity.getValue(property);
            row.add(value == null ? "" : Converter.convertTo((Object)value, (Class)property.getType()));
        }
        this.addRow(row);
    }

    @Override
    public void addEntities(Collection<MaltegoEntity> entities) {
        entities.stream().sorted((left, right) -> left.getTypeName().compareTo(right.getTypeName())).forEach(entity -> this.addEntity((MaltegoEntity)entity));
    }

    @Override
    public Iterator<MaltegoEntity> entityIterator() {
        return new Reader();
    }

    void createGroupHeader(MaltegoEntity entity) {
        if (this.lastEntity != null && this.lastEntity.getTypeName().equals(entity.getTypeName())) {
            return;
        }
        int size = entity.getProperties().size() + 1;
        this.groupProperties = new LinkedHashSet(size);
        this.groupDisplayHeader = new ArrayList<String>(size);
        this.groupTypeHeader = new ArrayList<String>(size);
        this.groupDisplayHeader.add(entity.getTypeName());
        this.groupTypeHeader.add(PropertyFlatMapFormat.ENTITY_START_ID);
        if (this.getRowCount() != 0) {
            this.addRow(new ArrayList<String>());
        }
        this.addRow(this.groupDisplayHeader);
        this.addRow(this.groupTypeHeader);
    }

    void updateGroupHeader(MaltegoEntity entity) {
        this.createGroupHeader(entity);
        this.lastEntity = entity;
        if (!this.groupProperties.addAll((Collection<PropertyDescriptor>)entity.getProperties())) {
            return;
        }
        for (PropertyDescriptor property : entity.getProperties()) {
            if (this.groupTypeHeader.contains(property.getName())) continue;
            this.groupDisplayHeader.add(property.getDisplayName());
            this.groupTypeHeader.add(property.getName());
        }
    }

    MaltegoEntity readEntity(Reader entityReader) {
        List row = (List)entityReader.rowIterator.next();
        while (row.isEmpty()) {
            List<String> groupHeader = this.readGroupHeader(entityReader);
            if (groupHeader == null) {
                return null;
            }
            if (!entityReader.rowIterator.hasNext()) {
                return null;
            }
            entityReader.propertyNames = groupHeader;
            row = (List)entityReader.rowIterator.next();
        }
        try {
            MaltegoEntitySpec entitySpec = this.getEntitySpec(entityReader.entityType);
            EntityID id = EntityID.parse((String)((String)row.get(0)));
            MaltegoEntity entity = this.entityFactory().createInstance(entitySpec, false, id, true);
            this.setEntityPropertyData(entity, entityReader.propertyNames, row);
            return entity;
        }
        catch (TypeInstantiationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    List<String> readGroupHeader(Reader entityReader) {
        String mark;
        if (!entityReader.rowIterator.hasNext()) {
            return null;
        }
        List row = (List)entityReader.rowIterator.next();
        entityReader.entityType = null;
        entityReader.propertyNames = null;
        do {
            if (!entityReader.rowIterator.hasNext()) {
                return null;
            }
            if (row != null && !row.isEmpty()) {
                entityReader.entityType = (String)row.get(0);
            }
            String string = mark = (row = (List)entityReader.rowIterator.next()).size() < 2 ? null : (String)row.get(0);
            if (row.size() <= 1 || !PropertyFlatMapFormat.ENTITY_TYPE.equals(row.get(1))) continue;
            mark = null;
        } while (!PropertyFlatMapFormat.ENTITY_START_ID.equals(mark));
        return entityReader.entityType == null ? null : row;
    }

    void setEntityPropertyData(MaltegoEntity entity, List<String> propertyNames, List<String> values) {
        PropertyDescriptorCollection properties = entity.getProperties();
        for (int column = 1; column < propertyNames.size() && column < values.size(); ++column) {
            String name;
            String value = values.get(column);
            if (value == null || value.isEmpty() || (name = propertyNames.get(column)) == null || name.isEmpty()) continue;
            PropertyDescriptor property = properties.stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
            if (property == null) {
                property = new PropertyDescriptor(String.class, name);
                properties.add(property);
            }
            Object data = Converter.convertFrom((String)value, (Class)property.getType());
            entity.setValue(property, data);
        }
    }

    class Reader
    extends EntityTableFormatter.Reader {
        private String entityType;

        protected Reader() {
        }

        @Override
        public MaltegoEntity next() {
            return GroupEntityTypeFormat.this.readEntity(this);
        }

        @Override
        protected List<String> readHeader() {
            return GroupEntityTypeFormat.this.readGroupHeader(this);
        }
    }
}

