/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.hub;

import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.transform.gen.TransformSource;
import com.paterva.maltego.transforms.tabular.TabularTransformSourceRepository;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.transforms.tabular.ui.TabularTransformSourceDetailsDisplayer;
import com.paterva.maltego.transforms.tabular.ui.hub.ObservableTabularTransformSourceHoverAwarePanel;
import com.paterva.maltego.transforms.tabular.ui.hub.TabularTransformSourceItemDescriptor;
import com.paterva.maltego.transforms.tabular.ui.hub.TabularTransformSourceLeftPanel;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.ui.FlatButton;
import com.paterva.maltego.util.ui.components.MultiLineLabel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TabularTransformSourceHoverPanel
extends ObservableTabularTransformSourceHoverAwarePanel {
    private static final ImageIcon IMG_DEL_NORMAL = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/seeds/ui/resources/DeleteNormal.png", (boolean)true);
    private static final ImageIcon IMG_DEL_HOVER = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/seeds/ui/resources/DeleteHover.png", (boolean)true);
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final TabularTransformSourceItemDescriptor item;
    private final FlatButton deleteButton;
    private Dimension detailsButtonSize = new Dimension();
    private JPanel buttonPanel;
    private JPanel deletePanel;
    private JLabel descriptionLabel;
    private JButton detailsButton;
    private JButton enableButton;
    private JPanel innerButtonPanel;
    private TabularTransformSourceLeftPanel leftPanel;
    private JLabel nameLabel;

    public TabularTransformSourceHoverPanel(TabularTransformSourceItemDescriptor item) {
        Args.notNull((Object)((Object)item), (String)"item");
        this.item = item;
        this.initComponents();
        this.deleteButton = new FlatButton((Icon)IMG_DEL_NORMAL, (Icon)IMG_DEL_HOVER);
        this.deleteButton.setBorder(null);
        this.deleteButton.addActionListener(e -> {
            String msg = "Are you sure you want to remove the Transform source completely?";
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, "Remove");
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                TabularTransformSource txSource = this.item.getTransformSource();
                String tabularGraphName = txSource.getTabularGraphName();
                MappingRegistry.getDefault().remove(tabularGraphName);
                TabularTransformSourceRepository.getInstance().remove((Object)txSource);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.weighty = 1.0;
        this.deletePanel.add((Component)this.deleteButton, gbc);
        this.detailsButtonSize = this.detailsButton.getPreferredSize();
        if (this.item != null) {
            this.update();
        }
        this.enableButton.setVisible(false);
    }

    @Override
    public TabularTransformSourceItemDescriptor getItem() {
        return this.item;
    }

    private void update() {
        this.updateName();
        this.updateEnable();
        this.updateDetails();
        this.updateDescription();
    }

    private Font getFontScaled(String key) {
        Args.notNull((Object)key, (String)"key");
        return LAF.getFont(key);
    }

    private void updateName() {
        this.nameLabel.setText(this.item.getTransformSource().getDisplayName());
        Color color = LAF.getColor("hub-item-name-hover-fg");
        this.nameLabel.setForeground(color);
        this.nameLabel.setFont(this.getFontScaled("hub-item-name-font"));
    }

    private void updateDescription() {
        String details = "";
        this.descriptionLabel.setForeground(LAF.getColor("hub-item-description-hover-fg"));
        this.descriptionLabel.setFont(this.getFontScaled("hub-item-description-hover-font"));
        this.descriptionLabel.setText(details);
    }

    private void updateEnable() {
        boolean enabled = true;
        String text = "Disable";
        if (!enabled) {
            text = "Enable";
        }
        this.enableButton.setText(text);
    }

    private Dimension getMax(Dimension ... d) {
        Dimension returnSize = new Dimension(0, 0);
        for (Dimension d1 : d) {
            if (d1.width > returnSize.width) {
                returnSize.width = d1.width;
            }
            if (d1.height <= returnSize.height) continue;
            returnSize.height = d1.height;
        }
        return returnSize;
    }

    private void updateDetails() {
        this.detailsButton.setPreferredSize(this.getMax(this.enableButton.getPreferredSize(), this.detailsButtonSize));
    }

    private void enableTransformSource() {
    }

    private void disableTransformSource() {
        String msg = "Are you sure you want to disable " + this.item.getTransformSource().getDisplayName() + "?";
        String title = "Disable Transform Source";
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, title);
        DialogDisplayer dialogDisplayer = DialogDisplayer.getDefault();
        if (NotifyDescriptor.OK_OPTION.equals(dialogDisplayer.notify((NotifyDescriptor)nd))) {
            // empty if block
        }
    }

    protected void onHoveredChanged() {
    }

    protected void onPanelClicked() {
    }

    private void initComponents() {
        this.leftPanel = new TabularTransformSourceLeftPanel(this.item);
        this.nameLabel = new JLabel();
        this.descriptionLabel = new MultiLineLabel();
        this.buttonPanel = new JPanel();
        this.innerButtonPanel = new JPanel();
        this.enableButton = new JButton();
        this.detailsButton = new JButton();
        this.deletePanel = new JPanel();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.leftPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(TabularTransformSourceHoverPanel.class, (String)"TabularTransformSourceHoverPanel.nameLabel.text"));
        this.nameLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.leftPanel.add((Component)this.nameLabel, "North");
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(TabularTransformSourceHoverPanel.class, (String)"TabularTransformSourceHoverPanel.descriptionLabel.text"));
        this.descriptionLabel.setVerticalAlignment(1);
        this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 3));
        this.descriptionLabel.setMaximumSize(new Dimension(2000, 2000));
        this.descriptionLabel.setVerticalTextPosition(1);
        this.leftPanel.add((Component)this.descriptionLabel, "Center");
        this.add(this.leftPanel, "Center");
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setLayout(new BorderLayout());
        this.innerButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.innerButtonPanel.setOpaque(false);
        this.innerButtonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.enableButton, (String)NbBundle.getMessage(TabularTransformSourceHoverPanel.class, (String)"TabularTransformSourceHoverPanel.enableButton.text"));
        this.enableButton.setMargin(new Insets(1, 10, 1, 10));
        this.enableButton.setMinimumSize(new Dimension(1, 1));
        this.enableButton.setOpaque(false);
        this.enableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabularTransformSourceHoverPanel.this.enableButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.innerButtonPanel.add((Component)this.enableButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.detailsButton, (String)NbBundle.getMessage(TabularTransformSourceHoverPanel.class, (String)"TabularTransformSourceHoverPanel.detailsButton.text"));
        this.detailsButton.setMargin(new Insets(1, 3, 1, 3));
        this.detailsButton.setMinimumSize(new Dimension(1, 1));
        this.detailsButton.setOpaque(false);
        this.detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabularTransformSourceHoverPanel.this.detailsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        this.innerButtonPanel.add((Component)this.detailsButton, gridBagConstraints);
        this.buttonPanel.add((Component)this.innerButtonPanel, "Center");
        this.deletePanel.setMinimumSize(new Dimension(1, 1));
        this.deletePanel.setOpaque(false);
        this.deletePanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.deletePanel, "East");
        this.add(this.buttonPanel, "East");
    }

    private void enableButtonActionPerformed(ActionEvent evt) {
    }

    private void detailsButtonActionPerformed(ActionEvent evt) {
        new TabularTransformSourceDetailsDisplayer().show((TransformSource)this.item.getTransformSource());
    }
}

