/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Set;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;

public abstract class ModuleInfo {
    public static final String PROP_ENABLED = "enabled";
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    protected ModuleInfo() {
    }

    public abstract String getCodeNameBase();

    public abstract int getCodeNameRelease();

    public abstract String getCodeName();

    public String getDisplayName() {
        String dn = (String)this.getLocalizedAttribute("OpenIDE-Module-Name");
        if (dn != null) {
            return dn;
        }
        return this.getCodeNameBase();
    }

    public abstract SpecificationVersion getSpecificationVersion();

    public String getImplementationVersion() {
        return (String)this.getAttribute("OpenIDE-Module-Implementation-Version");
    }

    public String getBuildVersion() {
        String bld = (String)this.getAttribute("OpenIDE-Module-Build-Version");
        return bld == null ? this.getImplementationVersion() : bld;
    }

    public abstract boolean isEnabled();

    public abstract Object getAttribute(String var1);

    public abstract Object getLocalizedAttribute(String var1);

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new NullPointerException("If you see this stack trace, please attach to: http://www.netbeans.org/issues/show_bug.cgi?id=22379");
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(String prop, Object old, Object nue) {
        this.changeSupport.firePropertyChange(prop, old, nue);
    }

    public abstract Set<Dependency> getDependencies();

    public abstract boolean owns(Class<?> var1);

    public ClassLoader getClassLoader() throws IllegalArgumentException {
        throw new UnsupportedOperationException("Must be overridden");
    }

    public String[] getProvides() {
        return new String[0];
    }
}

