/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.api.registry;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformSettingsLogger;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HubTransformSettingsLogger
extends TransformSettingsLogger {
    private static final Logger LOG = Logger.getLogger(HubTransformSettingsLogger.class.getName());

    protected void logHubItemSettings(TransformDefinition transform, TransformServerInfo server) {
        HubSeedRegistry hubRegistry = HubSeedRegistry.getDefault();
        HubSeedSettings hubSettings = HubSeedSettings.getDefault();
        List<HubSeedDescriptor> hubSeeds = server != null ? hubRegistry.getHubSeeds(server) : hubRegistry.getHubSeeds((TransformDescriptor)transform);
        if (hubSeeds != null && !hubSeeds.isEmpty()) {
            for (HubSeedDescriptor hubSeed : hubSeeds) {
                DisplayDescriptorCollection hubProperties;
                LOG.log(Level.FINE, "Hub Item: {0}", hubSeed.getDisplayName());
                DataSource hubItemSettings = hubSettings.getGlobalTransformSettings(hubSeed);
                if (hubItemSettings == null || (hubProperties = hubSettings.getGlobalTransformProperties(hubSeed, transform, false)) == null) continue;
                this.logDataSourceSettings(hubItemSettings, hubProperties);
            }
        } else {
            LOG.log(Level.FINE, "No hub items associated with this transform");
        }
    }
}

