/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.open;

import com.maltego.cloud.CloudGraph;
import com.maltego.cloud.ui.open.OpenFromCloudAction;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class CloudGraphOptionProcessor
extends OptionProcessor {
    private static final Logger LOG = Logger.getLogger(CloudGraphOptionProcessor.class.getName());
    public static final String MALTEGO_PROTOCOL = "maltego://";
    private static final String CLOUD_VIEW_URL_PREFIX = "maltego://cloud/open/";
    private static final String CLOUD_EDIT_URL_PREFIX = "maltego://cloud/edit/";
    public static final String MALTEGO_BETA_PROTOCOL = "maltegobeta://";
    private static final String BETA_CLOUD_VIEW_URL_PREFIX = "maltegobeta://cloud/open/";
    private static final String BETA_CLOUD_EDIT_URL_PREFIX = "maltegobeta://cloud/edit/";
    private static final Option CLOUD_GRAPH = Option.requiredArgument((char)'c', (String)"cloud");

    protected Set<Option> getOptions() {
        return Collections.singleton(CLOUD_GRAPH);
    }

    protected void process(Env env, Map<Option, String[]> maps) throws CommandException {
        String[] args = maps.get(CLOUD_GRAPH);
        if (args != null && args.length > 0) {
            String url = args[0];
            UIRunQueue.instance().queue(200, "Cloud Graph option processor", () -> {
                CloudGraph spec = CloudGraphOptionProcessor.getCloudGraph(url.trim());
                if (spec != null) {
                    CloudGraphOptionProcessor.openCloudGraph(spec);
                }
            });
        }
    }

    public static CloudGraph getCloudGraph(String url) {
        Boolean editable;
        String[] remainder;
        LOG.log(Level.INFO, "Cloud graph URL protocol argument: {0}", url);
        if (!url.matches("^(maltego://cloud/open/|maltego://cloud/edit/)[^/]+$") && !url.matches("^(maltegobeta://cloud/open/|maltegobeta://cloud/edit/)[^/]+$")) {
            RequestProcessor.getDefault().post(() -> SwingUtilities.invokeLater(() -> {
                if (MALTEGO_PROTOCOL.equalsIgnoreCase(url.trim()) || MALTEGO_BETA_PROTOCOL.equalsIgnoreCase(url.trim())) {
                    LOG.log(Level.WARNING, "Empty URL protocol {0}", url.trim());
                } else {
                    LOG.log(Level.WARNING, "Invalid cloud graph open URL: {0}", url);
                }
            }), 30);
            return null;
        }
        String version = null;
        if (url.contains(BETA_CLOUD_VIEW_URL_PREFIX)) {
            remainder = url.replace(BETA_CLOUD_VIEW_URL_PREFIX, "").trim().split("\\?");
            editable = Boolean.FALSE;
        } else if (url.contains(BETA_CLOUD_EDIT_URL_PREFIX)) {
            remainder = url.replace(BETA_CLOUD_EDIT_URL_PREFIX, "").trim().split("\\?");
            editable = Boolean.TRUE;
        } else if (url.contains(CLOUD_VIEW_URL_PREFIX)) {
            remainder = url.replace(CLOUD_VIEW_URL_PREFIX, "").trim().split("\\?");
            editable = Boolean.FALSE;
        } else {
            remainder = url.replace(CLOUD_EDIT_URL_PREFIX, "").trim().split("\\?");
            editable = Boolean.TRUE;
        }
        String cloudGraphId = remainder[0];
        LOG.log(Level.INFO, "Opening cloud graph with ID {0}", cloudGraphId);
        CloudGraph spec = null;
        try {
            spec = new CloudGraph(GraphID.parse((String)cloudGraphId), null, editable);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Cloud graph ID incorrect format {0}", cloudGraphId);
            return spec;
        }
        if (remainder.length > 1) {
            try {
                URI uri = new URI(url);
                String queryParam = uri.getQuery();
                Pattern pattern = Pattern.compile("versionId=([^&]+)");
                Matcher matcher = pattern.matcher(queryParam);
                if (matcher.find()) {
                    version = matcher.group(1);
                } else {
                    LOG.log(Level.WARNING, "Invalid URL param for cloud graph with ID {0}: {1}", new Object[]{cloudGraphId, remainder[1]});
                }
            }
            catch (URISyntaxException ex) {
                LOG.log(Level.WARNING, "Invalid URI format for cloud graph with ID {0}: {1}", new Object[]{cloudGraphId, url});
            }
            spec.setVersion(version);
        }
        return spec;
    }

    private static void openCloudGraph(CloudGraph spec) {
        OpenFromCloudAction action = (OpenFromCloudAction)SystemAction.get(OpenFromCloudAction.class);
        action.setCloudGraphId(spec.getCloudGraphId().toString());
        action.setCloudGraphVersion(spec.getVersion());
        action.setEditable(spec.isEditable());
        action.actionPerformed(null);
    }
}

