/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.openide.util.Utilities;

class OSFileChooser {
    private static final Logger LOG = Logger.getLogger(OSFileChooser.class.getName());
    private static JFileChooser _default;

    OSFileChooser() {
    }

    public static JFileChooser getDefault(boolean isLAFSet) {
        if (_default == null && !isLAFSet && Utilities.isMac()) {
            try {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"com.apple.laf.AquaLookAndFeel".equals(info.getClassName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (Exception ex) {
                LOG.log(Level.INFO, "Not able to set Mac OSFileChooser: {0}", ex.toString());
                return _default;
            }
            _default = new JFileChooser();
        }
        return _default;
    }
}

