/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphSelectionContext;
import com.paterva.maltego.ui.graph.GraphViewNotificationAdapter;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.StatusLineElementProvider;
import org.openide.util.Exceptions;
import yguard.A.J.SA;

public class SelectedStatusLine
implements StatusLineElementProvider {
    private final Component _component = new SelectedPanel();

    public Component getStatusLineElement() {
        return this._component;
    }

    private static class EmptyStatusLineElement
    implements StatusLineElementProvider {
        private final Component _empty = new JLabel();

        private EmptyStatusLineElement() {
        }

        public Component getStatusLineElement() {
            return this._empty;
        }
    }

    public static class HideTypingMode
    extends EmptyStatusLineElement {
    }

    public static class HideLineColumn
    extends EmptyStatusLineElement {
    }

    private class SelectedPanel
    extends JPanel {
        private SelectionListener _selectionListener;
        private final JLabel _label = new JLabel();
        private TopGraphListener _topGraphListener;
        private Timer _timer;

        public SelectedPanel() {
            this.setLayout(new FlowLayout(2, 0, 0));
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this._label.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.add(this._label);
            this._timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    SelectedPanel.this.updateText();
                    SelectedPanel.this._timer.stop();
                }
            });
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this._selectionListener = new SelectionListener();
            GraphSelectionContext.instance().addChangeListener(this._selectionListener);
            this._topGraphListener = new TopGraphListener();
            GraphEditorRegistry.getDefault().addPropertyChangeListener(this._topGraphListener);
            GraphViewNotificationAdapter.getDefault().addPropertyChangeListener(this._topGraphListener);
            this.updateText();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            GraphSelectionContext.instance().removeChangeListener(this._selectionListener);
            this._selectionListener = null;
            GraphEditorRegistry.getDefault().removePropertyChangeListener(this._topGraphListener);
            GraphViewNotificationAdapter.getDefault().removePropertyChangeListener(this._topGraphListener);
            this._topGraphListener = null;
        }

        private void scheduleUpdateText() {
            if (this._timer.isRunning()) {
                this._timer.restart();
            } else {
                this._timer.start();
            }
        }

        private void updateText() {
            try {
                this.updateTextInner();
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void updateTextInner() throws GraphStoreException {
            StringBuilder selectedStatus = new StringBuilder();
            GraphID graphID = GraphSelectionContext.instance().getTopGraphID();
            if (graphID != null && GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                SA graph = GraphSelectionContext.instance().getTopViewGraph();
                GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
                GraphStructureReader modelStructureReader = view.getModel().getGraphStructureStore().getStructureReader();
                int modelEntityCount = modelStructureReader.getEntityCount();
                int modelLinkCount = modelStructureReader.getLinkCount();
                int viewEntityCount = graph.v();
                int viewLinkCount = graph.y();
                GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
                if (selection.hasSelection()) {
                    int selectedModelEntityCount = selection.getSelectedModelEntityCount();
                    if (selectedModelEntityCount > 0) {
                        int selectedViewEntityCount;
                        this.appendXOfY(selectedStatus, selectedModelEntityCount, modelEntityCount, "entity");
                        if (modelEntityCount != viewEntityCount && selectedModelEntityCount != (selectedViewEntityCount = selection.getSelectedViewEntityCount())) {
                            selectedStatus.append(" (");
                            this.appendXOfY(selectedStatus, selectedViewEntityCount, viewEntityCount, "node");
                            selectedStatus.append(")");
                        }
                    } else {
                        int selectedViewLinkCount;
                        int selectedModelLinkCount = selection.getSelectedModelLinkCount();
                        this.appendXOfY(selectedStatus, selectedModelLinkCount, modelLinkCount, "link");
                        if (modelLinkCount != viewLinkCount && selectedModelLinkCount != (selectedViewLinkCount = selection.getSelectedViewLinkCount())) {
                            selectedStatus.append(" (");
                            this.appendXOfY(selectedStatus, selectedViewLinkCount, viewLinkCount, "edge");
                            selectedStatus.append(")");
                        }
                    }
                } else if (modelEntityCount > 0) {
                    this.appendCount(selectedStatus, modelEntityCount, "entity");
                    if (modelEntityCount != viewEntityCount) {
                        selectedStatus.append(" (");
                        this.appendCount(selectedStatus, viewEntityCount, "node");
                        selectedStatus.append(")");
                    }
                    if (modelLinkCount > 0) {
                        selectedStatus.append(", ");
                        this.appendCount(selectedStatus, modelLinkCount, "link");
                        if (modelLinkCount != viewLinkCount) {
                            selectedStatus.append(" (");
                            this.appendCount(selectedStatus, viewLinkCount, "edge");
                            selectedStatus.append(")");
                        }
                    }
                }
            }
            this._label.setText(selectedStatus.toString());
        }

        private void appendCount(StringBuilder stringBuilder, int x2, String singular) {
            stringBuilder.append(x2).append(" ").append(x2 == 1 ? singular : this.getPlural(singular));
        }

        private void appendXOfY(StringBuilder stringBuilder, int x2, int y2, String singular) {
            stringBuilder.append(x2).append(" of ").append(y2).append(" ").append(y2 == 1 ? singular : this.getPlural(singular));
        }

        private String getPlural(String singular) {
            return "entity".equals(singular) ? "entities" : singular + "s";
        }

        private class TopGraphListener
        implements PropertyChangeListener {
            private TopGraphListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                switch (evt.getPropertyName()) {
                    case "topmost": 
                    case "graphLoadingDone": {
                        SelectedPanel.this.scheduleUpdateText();
                        break;
                    }
                }
            }
        }

        private class SelectionListener
        implements ChangeListener {
            private SelectionListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e2) {
                SelectedPanel.this.scheduleUpdateText();
            }
        }
    }
}

