/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.cache.skeletons.SkeletonProviders;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.typing.editing.propertygrid.PropertySheetFactory;
import com.paterva.maltego.ui.graph.nodes.LinkNode;
import com.paterva.maltego.ui.graph.nodes.NodePropertySupport;
import com.paterva.maltego.ui.graph.nodes.PartProperties;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class LinkProperties
extends PartProperties {
    protected LinkProperties() {
    }

    public static Sheet createBasicSheet(Node node, MaltegoLink link, MaltegoLinkSpec spec) {
        return LinkProperties.createBasicSheet(null, node, link, spec);
    }

    public static Sheet createBasicSheet(GraphID graphID, Node node, MaltegoLink link, MaltegoLinkSpec spec) {
        Sheet sheet = PropertySheetFactory.createDefaultSheet();
        LinkProperties.addProperties(LinkProperties.getPropertySheetFactory(graphID), (SpecRegistry<? extends TypeSpec>)LinkRegistry.getDefault(), sheet, (MaltegoPart<? extends Guid>)link, spec.getPropertyConfiguration());
        return sheet;
    }

    public static Sheet createSheet(Node node, MaltegoLink link, MaltegoLinkSpec spec) {
        return LinkProperties.createSheet(null, node, link, spec);
    }

    public static Sheet createSheet(GraphID graphID, Node node, MaltegoLink link, MaltegoLinkSpec spec) {
        Sheet sheet = LinkProperties.createBasicSheet(graphID, node, link, spec);
        Sheet.Set defaultSet = sheet.get("");
        defaultSet.put((Node.Property)new Source(node));
        defaultSet.put((Node.Property)new Target(node));
        return sheet;
    }

    public static Node.Property<?> source() {
        return new Source(Node.EMPTY);
    }

    public static Node.Property<?> target() {
        return new Target(Node.EMPTY);
    }

    public static class Target
    extends NodePropertySupport.ReadOnly<String> {
        public Target(Node node) {
            super(node, "maltego.link.target", String.class, "Target", "The link target.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public String getValue() {
            Node node = this.node();
            if (node instanceof LinkNode) {
                try {
                    LinkNode linkNode = (LinkNode)node;
                    GraphID graphID = linkNode.getGraphID();
                    LinkID linkID = linkNode.getLinkID();
                    GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                    GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                    EntityID targetID = structureReader.getTarget(linkID);
                    MaltegoEntity targetEntity = SkeletonProviders.entitiesForGraph((GraphID)graphID).getEntitySkeleton(targetID);
                    return targetEntity.getDisplayString();
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }
    }

    public static class Source
    extends NodePropertySupport.ReadOnly<String> {
        public Source(Node node) {
            super(node, "maltego.link.source", String.class, "Source", "The link source.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public String getValue() {
            Node node = this.node();
            if (node instanceof LinkNode) {
                try {
                    LinkNode linkNode = (LinkNode)node;
                    GraphID graphID = linkNode.getGraphID();
                    LinkID linkID = linkNode.getLinkID();
                    GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                    GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                    EntityID sourceID = structureReader.getSource(linkID);
                    MaltegoEntity sourceEntity = SkeletonProviders.entitiesForGraph((GraphID)graphID).getEntitySkeleton(sourceID);
                    return sourceEntity.getDisplayString();
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }
    }
}

