/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.list;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.detailview.DetailViewTopComponent;
import com.paterva.maltego.detailview.html.HtmlSelectListener;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.ui.graph.HoverContext;
import com.paterva.maltego.ui.graph.actions.SelectionMode;
import com.paterva.maltego.ui.graph.find.ViewControlAdapterFocusFind;
import com.paterva.maltego.util.ui.MouseUtil;
import com.paterva.maltego.util.ui.ctxmenu.WindowPopupManager;
import com.paterva.maltego.view.list.bundle.EntityListViewDetailView;
import com.paterva.maltego.view.list.bundle.LinkListViewDetailView;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class EntityListDetailViewTopComponent
extends TopComponent
implements ViewControlAdapterFocusFind {
    private static final String ENTITY_LIST_VIEW = "EntityListView";
    private static final String LINK_LIST_VIEW = "LinkListView";
    private static final String PREFERRED_ID = "EntityListDetailViewTopComponent";
    private final EntityListViewDetailView entityListView = new EntityListViewDetailView();
    private final GraphDataListener graphDataListener = new GraphDataListener();
    private final GraphID graphID;
    private final GraphSelectionListener graphSelectionListener;
    private final HoverContext hoverContext;
    private final HoverListener hoverListener;
    private final HtmlLinkSelectionListener htmlSelectionListener;
    private final LinkListViewDetailView linkListView;
    private final ListViewSelectionListener listViewSelectionListener;
    private final RightClickListener rightClickListener;
    private boolean isExternalSync;

    public EntityListDetailViewTopComponent(GraphID graphID) {
        this.graphID = graphID;
        this.graphSelectionListener = new GraphSelectionListener();
        this.hoverContext = HoverContext.forContextID((String)"global");
        this.hoverListener = new HoverListener(this);
        this.htmlSelectionListener = new HtmlLinkSelectionListener();
        this.linkListView = new LinkListViewDetailView();
        this.listViewSelectionListener = new ListViewSelectionListener();
        this.rightClickListener = new RightClickListener((Component)((Object)this));
        this.isExternalSync = true;
        this.initComponents();
        JPanel entityListAndHeader = new JPanel(new BorderLayout());
        entityListAndHeader.add((Component)((Object)this.entityListView));
        this.add(entityListAndHeader, ENTITY_LIST_VIEW);
        JPanel linkListAndHeader = new JPanel(new BorderLayout());
        linkListAndHeader.add((Component)((Object)this.linkListView));
        this.add(linkListAndHeader, LINK_LIST_VIEW);
    }

    public void addNotify() {
        super.addNotify();
        this.entityListView.addSelectionChangeListener(this.listViewSelectionListener);
        this.linkListView.addSelectionChangeListener(this.listViewSelectionListener);
        GraphSelection.forGraph((GraphID)this.graphID).addPropertyChangeListener((PropertyChangeListener)this.graphSelectionListener);
        DetailViewTopComponent.findInstance().addHtmlSelectListener((HtmlSelectListener)this.htmlSelectionListener);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.rightClickListener, 16L);
        try {
            GraphStoreRegistry.getDefault().forGraphID(this.graphID).getGraphStructureStore().addPropertyChangeListener((PropertyChangeListener)this.graphDataListener);
            SelectionMode.addPropertyChangeListener((PropertyChangeListener)this.graphDataListener);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void addExternalNotify() {
        this.removeExternalNotify();
        this.hoverContext.addPropertyChangeListener((PropertyChangeListener)this.hoverListener);
    }

    public void removeNotify() {
        this.entityListView.removeSelectionChangeListener(this.listViewSelectionListener);
        this.linkListView.removeSelectionChangeListener(this.listViewSelectionListener);
        GraphSelection.forGraph((GraphID)this.graphID).removePropertyChangeListener((PropertyChangeListener)this.graphSelectionListener);
        DetailViewTopComponent.findInstance().removeHtmlSelectListener((HtmlSelectListener)this.htmlSelectionListener);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.rightClickListener);
        try {
            GraphStoreRegistry.getDefault().forGraphID(this.graphID).getGraphStructureStore().removePropertyChangeListener((PropertyChangeListener)this.graphDataListener);
            SelectionMode.removePropertyChangeListener((PropertyChangeListener)this.graphDataListener);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        super.removeNotify();
    }

    public void removeExternalNotify() {
        this.hoverContext.removePropertyChangeListener((PropertyChangeListener)this.hoverListener);
    }

    private void initComponents() {
        this.setLayout(new CardLayout());
    }

    public int getPersistenceType() {
        return 2;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public Set<EntityID> getSelectedEntities() {
        return this.entityListView.getSelectedModelEntities();
    }

    public Set<LinkID> getSelectedLinks() {
        return this.linkListView.getSelectedModelLinks();
    }

    private void updateViewSelectionContex() {
        GraphSelection selection = GraphSelection.forGraph((GraphID)this.graphID);
        if (SelectionMode.isEntities()) {
            this.entityListView.setSelectedEntities(selection.getSelectedModelEntities());
        } else {
            this.linkListView.setSelectedLinks(selection.getSelectedModelLinks());
        }
    }

    private void updateSelectionContex() {
        GraphSelection selection = GraphSelection.forGraph((GraphID)this.graphID);
        if (SelectionMode.isEntities()) {
            selection.setSelectedModelEntities((Collection)this.entityListView.getSelectedModelEntities());
        } else {
            selection.setSelectedModelLinks((Collection)this.linkListView.getSelectedModelLinks());
        }
    }

    public void updateContentSafe(boolean updateSelection) {
        try {
            this.showCard();
            this.updateContent();
            if (updateSelection) {
                this.updateViewSelectionContex();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateContent() throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this.graphID);
        GraphDataStoreReader reader = graphStore.getGraphDataStore().getDataStoreReader();
        if (SelectionMode.isEntities()) {
            Set entityIDs = reader.getEntityIDs();
            if (entityIDs != null && !entityIDs.isEmpty()) {
                this.entityListView.setEntities(this.graphID, entityIDs);
            }
        } else {
            Set linkIDs = reader.getLinkIDs();
            if (linkIDs != null && !linkIDs.isEmpty()) {
                this.linkListView.setLinks(this.graphID, linkIDs);
            }
        }
    }

    private void showCard() {
        CardLayout layout = (CardLayout)this.getLayout();
        if (SelectionMode.isEntities()) {
            layout.show((Container)((Object)this), ENTITY_LIST_VIEW);
        } else {
            layout.show((Container)((Object)this), LINK_LIST_VIEW);
        }
    }

    public void focusAndFlashFind() {
        if (SelectionMode.isEntities()) {
            this.entityListView.focusAndFlashFind();
        } else {
            this.linkListView.focusAndFlashFind();
        }
    }

    private class RightClickListener
    implements AWTEventListener {
        private final Component _component;

        public RightClickListener(Component c) {
            this._component = c;
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            MouseEvent m;
            if (e instanceof MouseEvent && (m = (MouseEvent)e).getID() == 500 && SwingUtilities.isRightMouseButton(m) && MouseUtil.isMouseInComponent((Component)this._component)) {
                EntityListDetailViewTopComponent.this.updateSelectionContex();
            }
        }
    }

    private class ListViewSelectionListener
    implements ChangeListener {
        private ListViewSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (EntityListDetailViewTopComponent.this.isExternalSync) {
                EntityListDetailViewTopComponent.this.updateSelectionContex();
            } else {
                EntityListDetailViewTopComponent.this.isExternalSync = true;
            }
        }
    }

    private class HtmlLinkSelectionListener
    implements HtmlSelectListener {
        private HtmlLinkSelectionListener() {
        }

        public void htmlEntitiesSelected(Set<EntityID> modelEntityIDs) {
            if (!SelectionMode.isEntities()) {
                SelectionMode.setNextMode();
            }
            EntityListDetailViewTopComponent.this.entityListView.setSelectedEntities(modelEntityIDs);
        }
    }

    private class HoverListener
    implements PropertyChangeListener {
        private final TopComponent parent;

        public HoverListener(TopComponent parent) {
            this.parent = parent;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("hoverChanged".equals(evt.getPropertyName()) && !WindowPopupManager.getInstance().isOpen()) {
                HoverContext graphHoverContext = HoverContext.forContextID((String)"graph");
                GraphPart hoverPart = EntityListDetailViewTopComponent.this.hoverContext.getHoverPart();
                if (MouseUtil.isMouseInComponent((Component)this.parent) && hoverPart != null) {
                    graphHoverContext.setHoverModelPart(hoverPart);
                } else {
                    graphHoverContext.setHoverModelPart(null);
                }
            }
        }
    }

    private class GraphSelectionListener
    implements PropertyChangeListener {
        private GraphSelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectionChanged".equals(evt.getPropertyName())) {
                GraphSelection selection = GraphSelection.forGraph((GraphID)EntityListDetailViewTopComponent.this.graphID);
                if (SelectionMode.isEntities()) {
                    Set eids2;
                    Set eids1 = EntityListDetailViewTopComponent.this.entityListView.getSelectedModelEntities();
                    if (!eids1.equals(eids2 = selection.getSelectedModelEntities())) {
                        EntityListDetailViewTopComponent.this.isExternalSync = false;
                        EntityListDetailViewTopComponent.this.entityListView.setSelectedEntities(eids2);
                    }
                } else {
                    Set lids2;
                    Set lids1 = EntityListDetailViewTopComponent.this.linkListView.getSelectedModelLinks();
                    if (!lids1.equals(lids2 = selection.getSelectedModelLinks())) {
                        EntityListDetailViewTopComponent.this.isExternalSync = false;
                        EntityListDetailViewTopComponent.this.linkListView.setSelectedLinks(lids2);
                    }
                }
            }
        }
    }

    private class GraphDataListener
    implements PropertyChangeListener {
        private GraphDataListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name != null) {
                switch (name) {
                    case "structureModified": {
                        EntityListDetailViewTopComponent.this.updateContentSafe(false);
                        break;
                    }
                    case "propertyModeChanged": {
                        EntityListDetailViewTopComponent.this.updateContentSafe(true);
                    }
                }
            }
        }
    }
}

