/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.imex;

import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.pws.api.PublicWebServices;
import com.paterva.maltego.pws.imex.SelectableService;
import com.paterva.maltego.pws.imex.SelectableServiceType;
import com.paterva.maltego.pws.imex.ServiceConfig;
import com.paterva.maltego.pws.imex.ServiceEntryFactory;
import com.paterva.maltego.pws.imex.ServiceExistInfo;
import com.paterva.maltego.pws.imex.ServiceWrapper;
import com.paterva.maltego.pws.imex.Util;
import com.paterva.maltego.pws.registry.TypedServicesRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ServicesImporter
extends ConfigImporter {
    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        List wrappers = reader.readAll((EntryFactory)new ServiceEntryFactory(), "Graph1");
        if (wrappers.isEmpty()) {
            return null;
        }
        HashMap<String, Set<PublicWebService>> servicesPerServiceType = new HashMap<String, Set<PublicWebService>>();
        for (ServiceWrapper wrapper : wrappers) {
            String serviceType = wrapper.getServiceType();
            PublicWebService service = wrapper.getService();
            HashSet<PublicWebService> services = (HashSet<PublicWebService>)servicesPerServiceType.get(serviceType);
            if (services == null) {
                services = new HashSet<PublicWebService>();
            }
            services.add(service);
            servicesPerServiceType.put(serviceType, services);
        }
        return this.createConfig(servicesPerServiceType);
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        TypedServicesRegistry.ReadOnly oldRegistry = new TypedServicesRegistry.ReadOnly(configRoot);
        Set<String> types = oldRegistry.getServiceTypes();
        HashMap<String, Set<PublicWebService>> servicesPerServiceType = new HashMap<String, Set<PublicWebService>>();
        for (String type : types) {
            servicesPerServiceType.put(type, oldRegistry.getAll(type));
        }
        return this.createConfig(servicesPerServiceType);
    }

    private Config createConfig(Map<String, Set<PublicWebService>> servicesPerServiceType) {
        if (servicesPerServiceType.isEmpty()) {
            return null;
        }
        ArrayList<SelectableServiceType> selectableServiceTypes = Util.createSelectables(servicesPerServiceType);
        ServiceExistInfo serviceExistInfo = new ServiceExistInfo();
        for (SelectableServiceType selectableServiceType : selectableServiceTypes) {
            String serviceType = selectableServiceType.getServiceType();
            boolean oneSelected = false;
            for (SelectableService selectableService : selectableServiceType) {
                PublicWebService service = selectableService.getService();
                boolean serviceSelected = !serviceExistInfo.exist(serviceType, service);
                selectableService.setSelected(serviceSelected);
                oneSelected |= serviceSelected;
            }
            selectableServiceType.setSelected(oneSelected);
        }
        return new ServiceConfig(selectableServiceTypes);
    }

    public int applyConfig(Config config) {
        ServiceConfig serviceConfig = (ServiceConfig)config;
        PublicWebServices registry = PublicWebServices.getDefault();
        int count = 0;
        for (SelectableServiceType selectableServiceType : serviceConfig.getSelectedServiceTypes()) {
            String serviceType = selectableServiceType.getServiceType();
            HashSet<PublicWebService> services = new HashSet<PublicWebService>(registry.getAll());
            for (SelectableService selectableService : selectableServiceType) {
                if (!selectableService.isSelected()) continue;
                PublicWebService service = selectableService.getService();
                services.remove(service);
                services.add(service);
                ++count;
            }
            for (PublicWebService service : services) {
                try {
                    String name = service.getName();
                    registry.replace(serviceType, name, service);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return count;
    }
}

