/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph;

import com.paterva.maltego.collab.graph.LogCallback;
import com.paterva.maltego.collab.graph.TransactionConflictDetector;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.util.SimilarStrings;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class TransactionConflictResolver {
    TransactionConflictResolver() {
    }

    public abstract GraphTransactionBatch outgoing(GraphTransactionBatch var1);

    public abstract GraphTransactionBatch[] incoming(GraphTransactionBatch var1, String var2, boolean var3, Date var4, List<GraphTransactionBatch> var5);

    public abstract void reset();

    private static class TransactionMarker {
        private GraphTransactionBatch _transaction;
        private boolean _conflicted = false;

        public TransactionMarker(GraphTransactionBatch transaction) {
            this._transaction = transaction;
        }

        public GraphTransactionBatch getTransaction() {
            return this._transaction;
        }

        public boolean isConflicted() {
            return this._conflicted;
        }

        public void markConflicted() {
            this._conflicted = true;
        }
    }

    public static class Default
    extends TransactionConflictResolver {
        private Map<Integer, TransactionMarker> _outgoing = new HashMap<Integer, TransactionMarker>();
        private TransactionConflictDetector _conflictDetector;
        private final LogCallback _log;

        public Default(TransactionConflictDetector detector, LogCallback log) {
            this._conflictDetector = detector;
            this._log = log;
        }

        @Override
        public synchronized GraphTransactionBatch outgoing(GraphTransactionBatch out) {
            TransactionMarker sequence = new TransactionMarker(out);
            this._outgoing.put(out.getSequenceNumber(), sequence);
            return out;
        }

        @Override
        public synchronized GraphTransactionBatch[] incoming(GraphTransactionBatch in, String name, boolean isMine, Date timestamp, List<GraphTransactionBatch> updateModifiedList) {
            if (isMine) {
                TransactionMarker out = this._outgoing.remove(in.getSequenceNumber());
                if (out == null) {
                    this._log.log(String.format("Reapplying own transaction \"%s\"", in.getDescription().getStringOne()), timestamp);
                    return new GraphTransactionBatch[]{this.createReplay(in)};
                }
                if (out.isConflicted()) {
                    this._log.log(String.format("Resolving conflict on \"%s\"", out.getTransaction().getDescription().getStringOne()), timestamp);
                    GraphTransactionBatch batch = this.createResolution(out.getTransaction());
                    updateModifiedList.add(batch);
                    return new GraphTransactionBatch[]{batch};
                }
                return new GraphTransactionBatch[0];
            }
            this.markConflicts(in, this._outgoing.values(), name, timestamp);
            return new GraphTransactionBatch[]{in};
        }

        private void markConflicts(GraphTransactionBatch in, Collection<TransactionMarker> out, String name, Date timestamp) {
            for (TransactionMarker marker : out) {
                if (marker.isConflicted() || !this._conflictDetector.haveConflict(in, marker.getTransaction())) continue;
                this._log.log(String.format("Conflict detected between \"%s\" from %s and my \"%s\"", in.getDescription().getStringOne(), name, marker.getTransaction().getDescription().getStringOne()), timestamp);
                marker.markConflicted();
            }
        }

        private GraphTransactionBatch createReplay(GraphTransactionBatch in) {
            SimilarStrings description = in.getDescription();
            GraphTransactionBatch out = new GraphTransactionBatch(new SimilarStrings(description.getFormatString(), description.getOneArgs(), description.getTwoArgs()), in.isSignificant(), new GraphTransaction[0]);
            for (GraphTransaction t : in.getTransactions()) {
                out.add(t);
            }
            return out;
        }

        private GraphTransactionBatch createResolution(GraphTransactionBatch in) {
            SimilarStrings description = in.getDescription();
            GraphTransactionBatch out = new GraphTransactionBatch(new SimilarStrings(description.getFormatString() + " [resolved]", description.getOneArgs(), description.getTwoArgs()), in.isSignificant(), new GraphTransaction[0]);
            for (GraphTransaction t : in.getTransactions()) {
                if (!t.getOperation().canConflict()) continue;
                out.add(t);
            }
            return out;
        }

        @Override
        public synchronized void reset() {
            this._outgoing.clear();
        }
    }

    public static final class None
    extends TransactionConflictResolver {
        @Override
        public GraphTransactionBatch outgoing(GraphTransactionBatch out) {
            return out;
        }

        @Override
        public GraphTransactionBatch[] incoming(GraphTransactionBatch in, String otherUserName, boolean isMine, Date timestamp, List<GraphTransactionBatch> updateModifiedList) {
            if (isMine) {
                return new GraphTransactionBatch[0];
            }
            return new GraphTransactionBatch[]{in};
        }

        @Override
        public void reset() {
        }
    }
}

