/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.home;

import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.welcome.home.HomeAndGraphTopComponentRegistry;
import com.paterva.maltego.welcome.home.HomeTopComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class HomeVsOtherWindowsSynchronizer {
    private static final Logger LOGGER = Logger.getLogger(HomeVsOtherWindowsSynchronizer.class.getName());
    private static final String PREF_FIRST_GRAPH = "maltego.windows.firstGraph";
    private static final String PREF_GRAPH_WINDOWS = "maltego.windows.graphWindows";
    private static HomeVsOtherWindowsSynchronizer _instance;
    private final HomeAndGraphTopComponentRegistry _registry = new HomeAndGraphTopComponentRegistry();
    private List<String> _graphWindows;
    private final Set<String> _opening = new HashSet<String>();
    private boolean _enabled = true;

    public static synchronized HomeVsOtherWindowsSynchronizer instance() {
        if (_instance == null) {
            _instance = new HomeVsOtherWindowsSynchronizer();
        }
        return _instance;
    }

    private HomeVsOtherWindowsSynchronizer() {
        this._registry.addPropertyChangeListener(new HomeAndGraphListener());
        WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)new WindowManagerListener());
    }

    public void setEnabled(boolean enabled) {
        LOGGER.log(Level.FINEST, "Enabled: {0}", enabled);
        this._enabled = enabled;
    }

    public void reset() {
        LOGGER.finest("Reset");
        this._graphWindows = null;
        Preferences prefs = this.getPrefs();
        prefs.putBoolean(PREF_FIRST_GRAPH, true);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void requestLastGraphTabActive() {
        String tcID;
        TopComponent tc2;
        WindowManager windowManager = WindowManager.getDefault();
        TopComponent.Registry windowRegistry = windowManager.getRegistry();
        TreeMap<Integer, String> tabs = new TreeMap<Integer, String>();
        for (TopComponent tc2 : windowRegistry.getOpened()) {
            if (!HomeAndGraphTopComponentRegistry.isGraphEditor(tc2)) continue;
            String tcID2 = windowManager.findTopComponentID(tc2);
            int tabPosition = tc2.getTabPosition();
            tabs.put(tabPosition, tcID2);
        }
        if (tabs.size() > 0 && (tcID = (String)tabs.get(tabs.lastKey())) != null && (tc2 = windowManager.findTopComponent(tcID)) != null && HomeAndGraphTopComponentRegistry.isGraphEditor(tc2)) {
            tc2.requestActive();
        }
    }

    private void closeWindows() {
        LOGGER.finest("Close Windows");
        WindowManager windowManager = WindowManager.getDefault();
        TopComponent.Registry windowRegistry = windowManager.getRegistry();
        for (TopComponent tc : windowRegistry.getOpened()) {
            GraphCookie cookie;
            String tcID = windowManager.findTopComponentID(tc);
            if (tc instanceof HomeTopComponent || HomeVsOtherWindowsSynchronizer.isPalette(tcID) || (cookie = (GraphCookie)tc.getLookup().lookup(GraphCookie.class)) != null) continue;
            LOGGER.log(Level.FINEST, "Closing: {0}", tcID);
            tc.close();
        }
    }

    private void openWindows() {
        LOGGER.finest("Open Windows");
        if (this._graphWindows == null) {
            Preferences prefs = this.getPrefs();
            String ids = prefs.get(PREF_GRAPH_WINDOWS, null);
            if (prefs.getBoolean(PREF_FIRST_GRAPH, true) || ids == null) {
                LOGGER.finest("First Graph Opened");
                prefs.putBoolean(PREF_FIRST_GRAPH, false);
                this.saveGraphOpenWindows();
            } else {
                LOGGER.log(Level.FINEST, "Loaded Open Windows: {0}", ids);
                this._graphWindows = StringUtilities.listFromString((String)ids);
            }
        }
        WindowManager windowManager = WindowManager.getDefault();
        for (String tcID : this._graphWindows) {
            TopComponent tc = windowManager.findTopComponent(tcID);
            if (tc == null) continue;
            this._opening.add(tcID);
            LOGGER.log(Level.FINEST, "Opening: {0}", tcID);
            LOGGER.log(Level.FINEST, "Busy opening (1): {0}", this._opening.toString());
            tc.open();
        }
    }

    private void saveGraphOpenWindows() {
        LOGGER.finest("Save Windows");
        this._graphWindows = new ArrayList<String>();
        WindowManager windowManager = WindowManager.getDefault();
        TopComponent.Registry windowRegistry = windowManager.getRegistry();
        for (TopComponent tc : windowRegistry.getOpened()) {
            String tcID = windowManager.findTopComponentID(tc);
            if (this.isHomeOrGraphTC(tc) || HomeVsOtherWindowsSynchronizer.isPalette(tcID)) continue;
            this._graphWindows.add(tcID);
        }
        String ids = StringUtilities.listToString(this._graphWindows);
        LOGGER.log(Level.FINEST, "Saved Open Windows: {0}", ids);
        this.getPrefs().put(PREF_GRAPH_WINDOWS, ids);
    }

    private static boolean isPalette(String tcID) {
        return "CommonPalette".equals(tcID);
    }

    private boolean isHomeOrGraphTC(Object newValue) {
        return this.isHomeTC(newValue) || this.isGraphEditor(newValue);
    }

    private boolean isHomeTC(Object value) {
        return value instanceof HomeTopComponent;
    }

    private boolean isGraphEditor(Object value) {
        if (value instanceof TopComponent) {
            TopComponent tc = (TopComponent)value;
            return HomeAndGraphTopComponentRegistry.isGraphEditor(tc);
        }
        return false;
    }

    private Preferences getPrefs() {
        return NbPreferences.forModule(this.getClass());
    }

    private class WindowManagerListener
    implements PropertyChangeListener {
        private WindowManagerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!HomeVsOtherWindowsSynchronizer.this._enabled) {
                return;
            }
            String propName = evt.getPropertyName();
            boolean opened = "tcOpened".equals(propName);
            if (opened || "tcClosed".equals(propName)) {
                Object newValue = evt.getNewValue();
                boolean homeOrGraphTC = HomeVsOtherWindowsSynchronizer.this.isHomeOrGraphTC(newValue);
                TopComponent topGraph = HomeVsOtherWindowsSynchronizer.this._registry.getTopmost();
                if (!homeOrGraphTC) {
                    LOGGER.log(Level.FINEST, "Non-Editor Top Window {0}", opened ? "Opened" : "Closed");
                    LOGGER.log(Level.FINEST, "   Window: {0}", newValue);
                    if (HomeVsOtherWindowsSynchronizer.this.isGraphEditor(topGraph)) {
                        LOGGER.finest("   While Graph is top editor.");
                        if (newValue instanceof TopComponent) {
                            TopComponent tc = (TopComponent)newValue;
                            String tcID = WindowManager.getDefault().findTopComponentID(tc);
                            LOGGER.log(Level.FINEST, "Busy opening (2): {0}", HomeVsOtherWindowsSynchronizer.this._opening.toString());
                            if (!HomeVsOtherWindowsSynchronizer.this._opening.remove(tcID) && !HomeVsOtherWindowsSynchronizer.isPalette(tcID)) {
                                HomeVsOtherWindowsSynchronizer.this.saveGraphOpenWindows();
                            }
                        }
                    } else {
                        LOGGER.finest("   While Graph is NOT top editor. (do nothing)");
                    }
                }
            }
        }
    }

    private class HomeAndGraphListener
    implements PropertyChangeListener {
        private HomeAndGraphListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!HomeVsOtherWindowsSynchronizer.this._enabled) {
                return;
            }
            if ("topmost".equals(evt.getPropertyName())) {
                Object oldValue = evt.getOldValue();
                Object newValue = evt.getNewValue();
                LOGGER.finest("Top Editor Changed");
                LOGGER.log(Level.FINEST, "   Old: {0}", oldValue);
                LOGGER.log(Level.FINEST, "   New: {0}", newValue);
                if (newValue == null || HomeVsOtherWindowsSynchronizer.this.isHomeTC(newValue)) {
                    HomeVsOtherWindowsSynchronizer.this.closeWindows();
                    if (newValue != null && newValue instanceof HomeTopComponent) {
                        HomeTopComponent homeTC = (HomeTopComponent)((Object)newValue);
                        SwingUtilities.invokeLater(() -> homeTC.update());
                    }
                } else if (!HomeVsOtherWindowsSynchronizer.this.isGraphEditor(oldValue) && HomeVsOtherWindowsSynchronizer.this.isGraphEditor(newValue)) {
                    HomeVsOtherWindowsSynchronizer.this.openWindows();
                }
            }
        }
    }
}

