/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.impl;

import com.paterva.maltego.util.ui.dialog.WizardSegment;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;

class OptionalPanelsWizardIterator
implements WizardDescriptor.Iterator {
    private WizardDescriptor _wd;
    private final List<WizardSegment> _segments;
    private int _currentSegment = 0;
    private int _currentStep = 0;

    public OptionalPanelsWizardIterator(List<WizardSegment> segments) {
        this._segments = segments;
    }

    public void initialize(WizardDescriptor wd) {
        this._wd = wd;
        for (WizardSegment segment : this._segments) {
            WizardUtilities.updatePanels((WizardDescriptor.Panel[])segment.getPanels());
            segment.initialize(wd);
        }
        this.updateContentPane();
        this._wd.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
    }

    public WizardDescriptor.Panel current() {
        return this.getCurrentIterator().current();
    }

    public String name() {
        return this.getCurrentIterator().name();
    }

    public boolean hasNext() {
        return this.getCurrentIterator().hasNext() || this.hasNextSegment();
    }

    private boolean hasNextSegment() {
        return this._currentSegment + 1 < this._segments.size();
    }

    public boolean hasPrevious() {
        return this.getCurrentIterator().hasPrevious() || this.hasPreviousSegment();
    }

    private boolean hasPreviousSegment() {
        return this._currentSegment > 0;
    }

    public void nextPanel() {
        WizardDescriptor.Iterator currentItr = this.getCurrentIterator();
        if (currentItr.hasNext()) {
            currentItr.nextPanel();
        } else {
            ++this._currentSegment;
        }
        ++this._currentStep;
        this.updateContentPane();
    }

    public void previousPanel() {
        WizardDescriptor.Iterator currentItr = this.getCurrentIterator();
        if (currentItr.hasPrevious()) {
            currentItr.previousPanel();
        } else {
            --this._currentSegment;
        }
        --this._currentStep;
        this.updateContentPane();
    }

    private void updateContentPane() {
        String[] steps = this.getContentData();
        for (WizardSegment segment : this._segments) {
            for (WizardDescriptor.Panel panel : segment.getPanels()) {
                Component c = panel.getComponent();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", this._currentStep);
                jc.putClientProperty("WizardPanel_contentData", steps);
            }
        }
    }

    private String[] getContentData() {
        ArrayList<String> allSteps = new ArrayList<String>();
        for (WizardSegment segment : this._segments) {
            String[] steps = segment.getContentPaneData();
            allSteps.addAll(Arrays.asList(steps));
            if (steps.length <= 0 || !steps[steps.length - 1].contains("...")) continue;
            break;
        }
        return allSteps.toArray(new String[allSteps.size()]);
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private WizardSegment getSegment(int index) {
        return this._segments.get(index);
    }

    private WizardDescriptor.Iterator getIterator(int index) {
        return this._segments.get(index).getIterator();
    }

    private WizardSegment getCurrentSegment() {
        return this.getSegment(this._currentSegment);
    }

    private WizardDescriptor.Iterator getCurrentIterator() {
        return this.getIterator(this._currentSegment);
    }

    private WizardDescriptor.Iterator getNextIterator() {
        return this.getIterator(this._currentSegment + 1);
    }
}

