/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.typing.editing.controls.FileBrowserPanel;
import com.paterva.maltego.typing.types.BinaryFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;

public class BinaryFileBrowserPanel
extends FileBrowserPanel {
    private BinaryFile _file;

    public BinaryFileBrowserPanel() {
        this.getTextField().setEditable(false);
        this.setSelectFiles(true);
        this.setSelectDirectories(false);
        this.setIconVisible(true);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BinaryFileBrowserPanel.this.updateFile(BinaryFileBrowserPanel.this.getFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFile(BinaryFile file) {
        if (file == null) {
            this.updateFile(null, (Icon)null);
        } else {
            File temp = null;
            try {
                try {
                    temp = File.createTempFile("temp", file.getExtension());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.updateFile(file, temp);
            }
            finally {
                if (temp != null) {
                    temp.delete();
                }
            }
        }
    }

    private void updateFile(File file) throws IOException {
        this.updateFile(BinaryFile.create((File)file), file);
    }

    private void updateFile(BinaryFile file, File originalFile) {
        Icon icon = null;
        if (originalFile != null) {
            icon = FileSystemView.getFileSystemView().getSystemIcon(originalFile);
        }
        this.updateFile(file, icon);
    }

    private void updateFile(BinaryFile file, Icon icon) {
        this._file = file;
        String display = file == null ? "(none)" : file.getFilename();
        if (icon == null) {
            icon = new ImageIcon();
        }
        this.getTextField().setText(display);
        this.setIcon(icon);
    }

    public void setValue(BinaryFile value) {
        this._file = value;
        this.updateFile(value);
    }

    public BinaryFile getValue() {
        return this._file;
    }
}

